<?php
include("db.php"); // Include your database connection

// Set content type to JSON
header('Content-Type: application/json');

// Check if variant_ID is provided in the POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Validate input
    if (isset($data['variant_ID'])) {
        $variantID = intval($data['variant_ID']); // Sanitize the input

        // Update query to set Delete_status to 1
        $sql = "UPDATE product_variants SET Delete_status = 1 WHERE variant_ID = $variantID";

        if ($conn->query($sql) === TRUE) {
            // Check if any rows were affected
            if ($conn->affected_rows > 0) {
                echo json_encode(['status' => 'success', 'message' => 'variant deleted successfully']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'variant not found or already deleted']);
            }
        } else {
            // Handle query error
            echo json_encode(['status' => 'error', 'message' => 'Failed to delete variant', 'error_detail' => $conn->error]);
        }
    } else {
        // Missing variant_ID in the request
        echo json_encode(['status' => 'error', 'message' => 'variant_ID is required']);
    }
} else {
    // Method not allowed
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method. Use POST.']);
}

$conn->close();
?>
